<?php

namespace Webkul\UVDesk\AutomationBundle\Repository;

use Doctrine\Common\Collections\Criteria;
use Webkul\UVDesk\AutomationBundle\Entity\Workflow;

/**
 * WorkflowRepository
 *
 * This class was generated by the Doctrine ORM. Add your own custom
 * repository methods below.
 */
class WorkflowRepository extends \Doctrine\ORM\EntityRepository
{
    public $safeFields = array('page','limit','sort','order','direction');
    const LIMIT = 10;

    public function getEventWorkflows($eventName, $isActive = true, $isPredefined = true)
    {
        return $this->getEntityManager()->createQueryBuilder()
            ->select('workflow')
            ->from(Workflow::class, 'workflow')
            ->leftJoin('workflow.workflowEvents', 'workflowEvents')
            ->where('workflow.status = :status')->setParameter('status', $isActive)
            ->andWhere('workflow.isPredefind = :isPredefined')->setParameter('isPredefined', $isPredefined)
            ->andWhere('workflowEvents.event = :eventType')->setParameter('eventType', $eventName)
            ->andWhere('workflow.relatedFieldId IS NULL') // related_field_id check
            ->andWhere('workflow.conditionMeta IS NULL')  // condition_meta check
            ->orderBy('workflow.sortOrder', Criteria::ASC)
            ->getQuery()->getResult();
    }


	public function getWorkflows(\Symfony\Component\HttpFoundation\ParameterBag $obj = null, $container) {
        $qb = $this->getEntityManager()->createQueryBuilder();
        $qb->select('w.id, w.name, w.status')->from($this->getEntityName(), 'w')
            ->orderBy('w.sortOrder', Criteria::ASC);
        
        return ['workflows' => $qb->getQuery()->getArrayResult()];
    }

        /**
         * DEBUGGED: Return only those workflow IDs whose serialized
         * conditions match the current ticket state. Instrumented to
         * dump SQL + params before execution.
         */
        public function findCandidateWorkflowIds(
            string $eventName,
            string $ticketTypeId,
            string $ticketStatusId,
            array $customFields
        ): array {
            $conn = $this->_em->getConnection();

            $sql = "
                SELECT w.id
                FROM uv_workflow w
                JOIN uv_workflow_events e ON w.id = e.workflow_id
                WHERE w.status = 1
                AND w.is_predefind = 1
                AND e.event = :event
                AND JSON_EXTRACT(w.condition_meta, '$.ticket_type') = :tt
                AND JSON_EXTRACT(w.condition_meta, '$.ticket_status') = :ts
            ";

            $params = [
                'event' => $eventName,
                'tt'    => $ticketTypeId,
                'ts'    => $ticketStatusId,
            ];

            $i = 0;
            foreach ($customFields as $fieldId => $values) {
                $path = "$.custom_field_{$fieldId}";
                $param = "cfval_{$i}";
                $sql .= " AND JSON_CONTAINS(w.condition_meta, :$param, '$path')";
                $params[$param] = json_encode(array_values($values));
                $i++;
            }

            $result = $conn->executeQuery($sql, $params); // ✅ Recommended approach
            $rows = $result->fetchAllAssociative();

            return array_column($rows, 'id');
        }


        // /**
        //  * Helper: build a SQL-LIKE pattern that hunts inside
        //  * the PHP-serialized `conditions` blob.
        //  */
        // private function likePattern(string $type, string $value, string $match = 'is'): string
        // {
        //     // convert non-breaking space (0xC2 0xA0) to normal space
        //     $value = str_replace("\xC2\xA0", ' ', $value);
        //     $type  = str_replace("\xC2\xA0", ' ', $type);

        //     $lenType  = mb_strlen($type,  'UTF-8');
        //     $lenMatch = mb_strlen($match, 'UTF-8');
        //     $lenValue = mb_strlen($value, 'UTF-8');

        //     return sprintf(
        //         '%%type";s:%d:"%s";%%match";s:%d:"%s";%%value";s:%d:"%s";%%',
        //         $lenType,  $type,
        //         $lenMatch, $match,
        //         $lenValue, $value
        //     );
        // }


    }


