<?php
require 'vendor/autoload.php'; // Load PhpSpreadsheet (install with: composer require phpoffice/phpspreadsheet)
use PhpOffice\PhpSpreadsheet\IOFactory;

function loadUvdeskEnv($filePath)
{
    if (!file_exists($filePath)) {
        die(".env file not found at: $filePath");
    }

    $lines = file($filePath, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
    foreach ($lines as $line) {
        if (strpos($line, '=') !== false) {
            list($key, $value) = explode('=', $line, 2);
            $key = trim($key);
            $value = trim(str_replace('"', '', $value)); // Remove quotes if present
            putenv("$key=$value");
            $_ENV[$key] = $value;
            $_SERVER[$key] = $value;
        }
    }
}

// // Path to UVDesk .env file (Update this path as per your UVDesk installation)
// $uvdeskEnvPath = '/var/www/html/uvdesk/.env'; // For Linux servers
 $uvdeskEnvPath = getcwd() . '/.env'; // For Windows XAMPP

// // Load UVDesk environment variables
loadUvdeskEnv($uvdeskEnvPath);

// Get DB credentials from UVDesk .env file
$databaseUrl = getenv('DATABASE_URL') ?: '';

if (!$databaseUrl) {
    die("DATABASE_URL not found in UVDesk .env file!");
}

// Parse DATABASE_URL (mysql://user:password@host:port/dbname)
$parsedUrl = parse_url($databaseUrl);

$host = $parsedUrl['host'] ?? 'localhost';
$dbname = isset($parsedUrl['path']) ? ltrim($parsedUrl['path'], '/') : die("Database name not found!");
$user = $parsedUrl['user'] ?? 'root';
$pass = $parsedUrl['pass'] ?? '';
$port = $parsedUrl['port'] ?? '3306';

// Establish database connection
try {
    $dsn = "mysql:host=$host;port=$port;dbname=$dbname";
    $pdo = new PDO($dsn, $user, $pass);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
    echo "Connected successfully to UVDesk database.\n";
} catch (PDOException $e) {
    die("Could not connect to the database: " . $e->getMessage());
}

try {
    $pdo = new PDO("mysql:host=$host;dbname=$dbname;charset=utf8mb4", $user, $pass);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

    $filePath = __DIR__ . "/GST Client list.xlsx";
    $spreadsheet = IOFactory::load($filePath);
    $sheet = $spreadsheet->getActiveSheet();
    $data = $sheet->toArray();

    // Loop through each row (Skipping the first row - Header)
    foreach (array_slice($data, 1) as $row) {
        $business_name = trim($row[0]);
        $gst_number = trim($row[1]);
        $registration_type = trim($row[2]);
    
        if (!empty($business_name) && !empty($gst_number)) {
            // Convert business name to lowercase and remove spaces
            $email_prefix = strtolower(preg_replace('/\s+/', '', $business_name));
    
            // Ensure a unique email by appending GSTIN or a random number
            $email = $email_prefix . "_" . substr($gst_number, -4) . "@example.com";
    
            // Hash a default password
            $password = password_hash("default123", PASSWORD_BCRYPT);
    
            try {
                // Insert into uv_user
                $stmt = $pdo->prepare("INSERT INTO uv_user (email, password, first_name, is_enabled) VALUES (?, ?, ?, ?)");
                $stmt->execute([$email, $password, $business_name, 1]);
                $user_id = $pdo->lastInsertId();
    
                // Insert into uv_user_instance
                $stmt = $pdo->prepare("INSERT INTO uv_user_instance (user_id, source, designation, gst_number, supportRole_id, is_active, is_verified, created_at, updated_at) 
                      VALUES (?, ?, ?, ?, ?, ?, ?, NOW(), NOW())");
                $stmt->execute([$user_id, 'website', $registration_type, $gst_number, 4, 1, 1]);
            
                echo "Customer added: $business_name ($email)\n";
            } catch (PDOException $e) {
                echo "Error inserting customer $business_name: " . $e->getMessage() . "\n";
            }
        }
    }
} catch (PDOException $e) {
    die("DB Error: " . $e->getMessage());
}
    
?>
